/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.objmgr.cec;

import com.ibm.hsc.common.util.HardwareServerMessage;
import com.ibm.hsc.common.util.PIHscLockUtils;
import com.ibm.hsc.common.util.PIParseResponse;
import com.ibm.hsc.fsp.cmdhelpers.CodAsyncMsg;
import com.ibm.hsc.fsp.cmdhelpers.FspCodAsyncEventData;
import com.ibm.hsc.indication.client.HSCBroadcastMsg;
import com.ibm.hsc.indication.client.HSCBroadcastMsgImpl;
import com.ibm.hsc.indication.server.HSCEventIndicationMgr;
import com.ibm.hsc.lock.Lock;
import com.ibm.hsc.objmgr.OmUtils;
import com.ibm.hsc.objmgr.cec.OmCecMgr;
import com.ibm.hsc.objmgr.cec.OmCecSendCoDAsyncMsg;
import com.ibm.hsc.objmgr.sys.OmSysAsyncEvtHandler;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;

public class OmCecAsyncEvtHandler
extends OmSysAsyncEvtHandler {
    private static final int FSP_BROADCAST_OPCODE = 45247;
    private static final int HPYP_EVENT_TARGET = 32769;
    private static final int HPYP_EVENT_OPCODE = 3;
    private static final int PIPE_EVENT_TARGET = 32773;
    private static final int PIPE_EVENT_OPCODE = 770;
    private static final int VSP_EVENT_TARGET = 32771;
    private static final int VSP_EVENT_OPCODE = 3;
    private static final int VSP_SRC_EVENT_OPCODE = 515;
    private static final int COD_EVENT_TARGET = 32772;
    private static final int COD_EVENT_OPCODE = 3;
    private static final String FSP_BROADCAST_MESSAGE = "OUTBOUND_BROADCAST_MSG";
    private static final String BROADCAST_MSG_LEN = "MSG_LEN";
    private static final String BROADCAST_TOOL_TYPE = "TOOL_TYPE";
    private static final String BROADCAST_HMC_ID = "HMC_ID";
    private static final String BROADCAST_DATA = "DATA";
    private static final String FSP_ASYNC_EVENT = "ASYNC_EVENT_NOTIFICATION";
    private static final String FSP_EVENT_MASK_LENGTH = "MASK_LENGTH";
    private static final String FSP_EVENT_MASK_DATA = "DATA";
    private static final String LPAR_ASYNC_STATE_CHANGE = "LPAR_ASYNC_STATE_CHANGE";
    private static final String GBL_CHG_FLG = "GBL_CHG_FLG";
    private static final String LPAR_CHANGE = "LPAR_CHANGE";
    private static final String LPAR_NUM = "LPAR_NUM";
    private static final String LPAR_CHG_LIST = "LPAR_CHG_LIST";
    private static final String LPAR_ID = "LPAR_ID";
    private static final String LPAR_CHG_FLG = "LPAR_CHG_FLG";
    private static final String BUS_CHANGE = "BUS_CHANGE";
    private static final String BUS_MASK_LENGTH = "BUSSES";
    private static final String BUS_MASK = "DATA";
    private static final String VSP_ASYNC_STATE_CHANGE = "VSP_ASYNC_STATE_CHANGE";
    private static final String VSP_SRC_ASYNC_STATE_CHANGE = "VSP_SRC_ASYNC_STATE_CHANGE";
    private static final String VSP_EVENT_LENGTH = "LENGTH";
    private static final String VSP_EVENT_MASK = "MASK";
    private static final String HYPER_PIPE_RESP_ASYNC = "HYPER_PIPE_RESP_ASYNC";
    private static final String HYPER_PIPE_RESP_ASYNC_EXCH_CAPS = "HYPER_PIPE_RESP_ASYNC_EXCH_CAPS";
    private static final byte[] FSP_EVENT_REG_MASK = new byte[]{123, -43, 24, 0};
    private static final int FSP_BROADCAST_EVT_BIT = 1;
    private static final int FSP_CEC_STATE_CHANGE_EVT_BIT = 2;
    private static final int FSP_PHYP_STATE_CHANGE_EVT_BIT = 3;
    private static final int FSP_TAKEOVER_EVT_BIT = 4;
    private static final int FSP_PFT_EVT_LOG_EVT_BIT = 6;
    private static final int FSP_PFT_DUMP_EVT_BIT = 7;
    private static final int FSP_NEW_SRC_EVT_BIT = 8;
    private static final int FSP_LOCK_CHANGE_EVT_BIT = 9;
    private static final int FSP_SMA_EVT_BIT = 11;
    private static final int FSP_SAVE_AREA_CHANGE_EVT_BIT = 13;
    private static final int FSP_VTERM_AVL_EVT_BIT = 15;
    private static final int FSP_CEC_NAME_CHANGE_EVT_BIT = 19;
    private static final int FSP_SYS_ATTN_CHANGE_EVT_BIT = 20;
    private static final int COD_KEY_PROCESSING_SUCCESS_EVT_BIT = 0;
    private static final int COD_KEY_PROCESSING_FAILURE_EVT_BIT = 1;
    private static final int COD_DISPLAY_MSG_EVT_BIT = 2;
    private static final int COD_ONOFF_PROC_STATE_CHANGE_EVT_BIT = 3;
    private static final int COD_ONOFF_MEM_STATE_CHANGE_EVT_BIT = 4;
    private static final int COD_METERED_PROC_STATE_CHANGE_EVT_BIT = 5;
    private static final int COD_METERED_MEM_STATE_CHANGE_EVT_BIT = 6;
    private static final int COD_TRIAL_PROC_STATE_CHANGE_EVT_BIT = 7;
    private static final int COD_TRIAL_MEM_STATE_CHANGE_EVT_BIT = 8;
    private static final int COD_STATE_CHANGE_EVT_BIT = 9;
    private int REBUILD_CEC = 1;
    private int REBUILD_IO = 2;

    public OmCecAsyncEvtHandler(OmCecMgr omCecMgr) {
        super(omCecMgr);
    }

    public void reinitialize() {
        try {
            System.out.println("send down event mask sub");
            this.mSysMgr.getCmdHelper().setEventNotificationMask(FSP_EVENT_REG_MASK);
            this.mSysMgr.getCmdHelper().acknowledgeOutstandingEvents();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(int n, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        block26: {
            int n2 = 0;
            OmCecMgr omCecMgr = (OmCecMgr)this.mSysMgr;
            try {
                System.out.println("Handles event for " + omCecMgr.getCecName() + " minorCode is " + n);
                PIParseResponse pIParseResponse = new PIParseResponse(byArray2);
                System.out.println("after parse response");
                int n3 = pIParseResponse.getTarget();
                int n4 = pIParseResponse.getOpCode();
                System.out.println("target: " + n3 + " opcode: " + n4);
                if (n3 == 28672 && n4 == 1) {
                    System.out.println("fsp event");
                    try {
                        this.handleFSPEvent(pIParseResponse, byArray);
                        break block26;
                    }
                    finally {
                        this.acknowledgeFspEvent();
                    }
                }
                if (n3 == 28672 && n4 == 45247) {
                    this.handleBroadcastEvent(pIParseResponse);
                    break block26;
                }
                if (n3 == 32771 && n4 == 3) {
                    try {
                        System.out.println("got an event phyp vsp");
                        this.handleVspEvent(pIParseResponse);
                        break block26;
                    }
                    finally {
                        this.acknowledgeVspEvent(byArray3);
                    }
                }
                if (n3 == 32771 && n4 == 515) {
                    try {
                        System.out.println("got an event phyp vsp src");
                        this.handleVspSrcEvent(pIParseResponse);
                        break block26;
                    }
                    finally {
                        this.acknowledgeVspSrcEvent(byArray3);
                    }
                }
                if (n3 == 32769 && n4 == 3) {
                    try {
                        System.out.println("got an event phyp lpar");
                        this.handlePHYPEvent(pIParseResponse);
                        break block26;
                    }
                    finally {
                        this.acknowledgePHYPEvent(byArray3);
                    }
                }
                if (n3 == 32773 && n4 == 770) {
                    try {
                        System.out.println("got an event pipe");
                        n2 = this.handleHypervisorPipeEvent(byArray2, pIParseResponse);
                        break block26;
                    }
                    finally {
                        this.acknowledgeHypPipeResponse(byArray3, n2);
                    }
                }
                if (n3 != 32772 || n4 != 3) break block26;
                try {
                    System.out.println("got an event cod");
                    this.handleCodEvent(byArray2, pIParseResponse);
                }
                finally {
                    this.acknowledgeCodEvent(byArray3);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleFSPEvent(PIParseResponse pIParseResponse, byte[] byArray) throws Exception {
        block16: {
            Hashtable hashtable = pIParseResponse.getParsedData(FSP_ASYNC_EVENT);
            byte[] byArray2 = (byte[])hashtable.get("DATA");
            boolean bl = false;
            OmUtils omUtils = OmUtils.getInstance();
            OmCecMgr omCecMgr = (OmCecMgr)this.mSysMgr;
            if (omUtils.isBitOnInByteArray(byArray2, 4)) {
                System.out.println("got an event fsp take over");
                this.handleFSPTakeoverEvent();
            }
            if (omUtils.isBitOnInByteArray(byArray2, 6)) {
                System.out.println("got an event fsp platform event log");
                this.handlePlatformLogEvent(byArray);
            }
            if (omUtils.isBitOnInByteArray(byArray2, 7)) {
                System.out.println("got an event fsp platform dump");
                this.handlePlatformDumpEvent(byArray);
            }
            if (omUtils.isBitOnInByteArray(byArray2, 15)) {
                System.out.println("got an event fsp vterm");
                this.handleVtermBufAvlEvent();
            }
            if (omUtils.isBitOnInByteArray(byArray2, 20)) {
                System.out.println("got an event fsp system attn change");
                this.handleSysAttnChangeEvent();
            }
            if (!(omUtils.isBitOnInByteArray(byArray2, 2) || omUtils.isBitOnInByteArray(byArray2, 3) || omUtils.isBitOnInByteArray(byArray2, 13) || omUtils.isBitOnInByteArray(byArray2, 19))) {
                if (!omUtils.isBitOnInByteArray(byArray2, 8)) return;
            }
            Lock lock = null;
            try {
                lock = Lock.getInstance("root/ibmhscS1_0", omCecMgr.getCecName());
                lock.lock(4);
                System.out.println("got the cimom cec lock in fsp event handler");
                if (omUtils.isBitOnInByteArray(byArray2, 2) || omUtils.isBitOnInByteArray(byArray2, 3)) {
                    System.out.println("cec state change event");
                    bl = this.handleCecStateChangeEvent();
                    this.handSvrEvtSubs(0, byArray2);
                }
                if (omUtils.isBitOnInByteArray(byArray2, 13) && !bl) {
                    System.out.println("got an event fsp save area change");
                    this.handleSaveAreaChangeEvent();
                }
                if (omUtils.isBitOnInByteArray(byArray2, 19) && !bl) {
                    System.out.println("got an event fsp cec name change");
                    this.handleCecNameChangeEvent();
                }
                if (omUtils.isBitOnInByteArray(byArray2, 8) && !bl) {
                    System.out.println("got an event fsp new src");
                    this.handleSRCValChangeEvent();
                }
                Object var10_9 = null;
                if (lock == null) break block16;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (lock == null) {
                    System.out.println("could not get lock  in fsp event handler");
                    throw throwable;
                }
                try {
                    lock.unlock();
                    System.out.println("released the cimom cec lock in fsp event handler");
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable2.printStackTrace();
                    throw throwable;
                }
            }
            try {}
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return;
            }
            lock.unlock();
            System.out.println("released the cimom cec lock in fsp event handler");
            return;
        }
        System.out.println("could not get lock  in fsp event handler");
    }

    private void handleBroadcastEvent(PIParseResponse pIParseResponse) {
        try {
            Hashtable hashtable = pIParseResponse.getParsedData(FSP_BROADCAST_MESSAGE);
            UnsignedInt32 unsignedInt32 = (UnsignedInt32)hashtable.get(BROADCAST_TOOL_TYPE);
            String string = (String)hashtable.get(BROADCAST_HMC_ID);
            UnsignedInt16 unsignedInt16 = (UnsignedInt16)hashtable.get(BROADCAST_MSG_LEN);
            byte[] byArray = (byte[])hashtable.get("DATA");
            HSCBroadcastMsg hSCBroadcastMsg = this.createMsgObject(unsignedInt32.intValue(), string, byArray);
            HSCEventIndicationMgr.getInstance().sendIndication(300, this.mSysMgr.getObject(), hSCBroadcastMsg);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private HSCBroadcastMsg createMsgObject(int n, String string, byte[] byArray) {
        int n2 = HardwareServerMessage.bytesToUShort(byArray, 0);
        int n3 = HardwareServerMessage.bytesToUShort(byArray, 2);
        int n4 = HardwareServerMessage.bytesToUInt(byArray, 4);
        int n5 = HardwareServerMessage.bytesToUShort(byArray, 8);
        int n6 = HardwareServerMessage.bytesToUShort(byArray, 10);
        String string2 = new String(byArray, 12, n5);
        String string3 = new String(byArray, 12 + n5, n6);
        byte[] byArray2 = string3.getBytes();
        return new HSCBroadcastMsgImpl(n, string, n2, string2, n3, n4, byArray2);
    }

    private boolean handleCecStateChangeEvent() {
        return ((OmCecMgr)this.mSysMgr).cecStateChangedAction(false);
    }

    private void handleFSPTakeoverEvent() {
        HSCEventIndicationMgr.getInstance().sendIndication(303, this.mSysMgr.getObject(), null);
    }

    private void handleSRCValChangeEvent() {
        ((OmCecMgr)this.mSysMgr).cecSrcChanged();
    }

    private void handleLockStateChangeEvent() {
    }

    private void handleSaveAreaChangeEvent() {
        ((OmCecMgr)this.mSysMgr).saveAreaChanged();
    }

    private void handleVtermBufAvlEvent() {
    }

    private void handleCecNameChangeEvent() {
        ((OmCecMgr)this.mSysMgr).cecNameChanged();
    }

    private void handleSysAttnChangeEvent() {
        HSCEventIndicationMgr.getInstance().sendIndication(304, this.mSysMgr.getObject(), null);
    }

    private void handlePHYPEvent(PIParseResponse pIParseResponse) {
        try {
            Hashtable hashtable = pIParseResponse.getParsedData(LPAR_ASYNC_STATE_CHANGE);
            int n = this.phypGlobalChange(hashtable);
            if (n == this.REBUILD_CEC) {
                return;
            }
            this.phypLparChange(hashtable);
            if (n == 0) {
                this.phypBusChange(hashtable);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int phypGlobalChange(Hashtable hashtable) throws Exception {
        Lock lock;
        block16: {
            int n;
            block17: {
                int n2;
                block14: {
                    block15: {
                        byte[] byArray = (byte[])hashtable.get(GBL_CHG_FLG);
                        OmCecMgr omCecMgr = (OmCecMgr)this.mSysMgr;
                        int n3 = 0;
                        if (byArray != null && byArray.length > 0) {
                            n3 = byArray[byArray.length - 1];
                        }
                        System.out.println("gblChgFlg " + (n3 &= 0xFF));
                        lock = null;
                        boolean bl = false;
                        try {
                            System.out.println("got the cimom cec lock1 in phyp event handler");
                            lock = (n3 & 4) != 0 ? Lock.getInstance("root/ibmhscS1_0", omCecMgr.getCecName()) : PIHscLockUtils.getCecSubLockInstance(omCecMgr.getCecName(), 5);
                            lock.lock(4);
                            if ((n3 & 1) != 0) {
                                System.out.println("phyp global change hypervisor state");
                                if (omCecMgr.phypStateChangedAction()) {
                                    System.out.println("cec state change already rebuilt the whole cec");
                                    n2 = this.REBUILD_CEC;
                                    Object var9_9 = null;
                                    if (lock == null) break block14;
                                    break block15;
                                }
                            }
                            if ((n3 & 2) != 0) {
                                System.out.println("phyp global change avail res");
                                omCecMgr.cecAvailResChangedAction();
                            }
                            if ((n3 & 4) == 0) break block16;
                            System.out.println("phyp global change IO drawer");
                            omCecMgr.ioDrawerChangeAction();
                            n = this.REBUILD_IO;
                            break block17;
                        }
                        catch (Throwable throwable) {
                            Object var9_12 = null;
                            if (lock == null) {
                                System.out.println("could not get lock1  in phyp event handler");
                                throw throwable;
                            }
                            try {
                                lock.unlock();
                                System.out.println("released the cimom cec lock1 in phyp event handler");
                                throw throwable;
                            }
                            catch (Throwable throwable2) {
                                throwable2.printStackTrace();
                                throw throwable;
                            }
                        }
                    }
                    try {}
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        return n2;
                    }
                    lock.unlock();
                    System.out.println("released the cimom cec lock1 in phyp event handler");
                    return n2;
                }
                System.out.println("could not get lock1  in phyp event handler");
                return n2;
            }
            Object var9_10 = null;
            if (lock != null) {
                try {}
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    return n;
                }
                lock.unlock();
                System.out.println("released the cimom cec lock1 in phyp event handler");
                return n;
            }
            System.out.println("could not get lock1  in phyp event handler");
            return n;
        }
        Object var9_11 = null;
        if (lock != null) {
            try {}
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return 0;
            }
            lock.unlock();
            System.out.println("released the cimom cec lock1 in phyp event handler");
            return 0;
        }
        System.out.println("could not get lock1  in phyp event handler");
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void phypLparChange(Hashtable hashtable) throws Exception {
        Lock lock = null;
        UnsignedInt16 unsignedInt16 = (UnsignedInt16)hashtable.get(LPAR_NUM);
        System.out.println("lparNum: " + unsignedInt16);
        if (unsignedInt16 != null && unsignedInt16.intValue() > 0) {
            System.out.println("chg_list: " + hashtable.get(LPAR_CHG_LIST).getClass().getName());
            Object[] objectArray = (Object[])hashtable.get(LPAR_CHG_LIST);
            for (int i = 0; i < objectArray.length; ++i) {
                Throwable throwable2222;
                Object var11_10;
                int n;
                block13: {
                    Hashtable hashtable2 = (Hashtable)objectArray[i];
                    n = ((UnsignedInt16)hashtable2.get(LPAR_ID)).intValue();
                    int n2 = ((UnsignedInt16)hashtable2.get(LPAR_CHG_FLG)).intValue();
                    System.out.println("lparId " + n + " changeFlag " + n2);
                    lock = null;
                    lock = Lock.getInstance("root/ibmhscS1_0", ((OmCecMgr)this.mSysMgr).getCecName(), "" + n);
                    lock.lock(4);
                    System.out.println("got the cimom lpar lock for lpar " + n + "  in phyp event handler");
                    ((OmCecMgr)this.mSysMgr).lparChanged(n, n2);
                    var11_10 = null;
                    if (lock == null) break block13;
                    System.out.println("released the cimom lpar lock in phyp event handler");
                    try {
                        lock.unlock();
                    }
                    catch (Throwable throwable2222) {
                        throwable2222.printStackTrace();
                    }
                    continue;
                }
                System.out.println("could not get lpar lock for " + n + " in phyp event handler");
                {
                    continue;
                    catch (Throwable throwable3) {
                        throwable3.printStackTrace();
                        var11_10 = null;
                        if (lock != null) {
                            System.out.println("released the cimom lpar lock in phyp event handler");
                            try {
                                lock.unlock();
                            }
                            catch (Throwable throwable2222) {
                                throwable2222.printStackTrace();
                            }
                            continue;
                        }
                        System.out.println("could not get lpar lock for " + n + " in phyp event handler");
                        continue;
                    }
                }
                catch (Throwable throwable4) {
                    var11_10 = null;
                    if (lock != null) {
                        System.out.println("released the cimom lpar lock in phyp event handler");
                        try {
                            lock.unlock();
                        }
                        catch (Throwable throwable2222) {
                            throwable2222.printStackTrace();
                        }
                    } else {
                        System.out.println("could not get lpar lock for " + n + " in phyp event handler");
                    }
                    throw throwable4;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void phypBusChange(Hashtable hashtable) throws Exception {
        block7: {
            Lock lock = null;
            try {
                lock = Lock.getInstance("root/ibmhscS1_0", ((OmCecMgr)this.mSysMgr).getCecName());
                lock.lock(4);
                System.out.println("got the cimom cec lock2 in phyp event handler");
                UnsignedInt16 unsignedInt16 = (UnsignedInt16)hashtable.get(BUS_MASK_LENGTH);
                System.out.println("busMaskLen: " + unsignedInt16);
                if (unsignedInt16 != null && unsignedInt16.intValue() > 0) {
                    byte[] byArray = (byte[])hashtable.get("DATA");
                    Vector vector = OmUtils.getInstance().getIdVecFromTwinBitMask(byArray);
                    System.out.println("busIds: " + vector);
                    ((OmCecMgr)this.mSysMgr).ioInfoChanged(null, vector);
                }
                Object var7_6 = null;
                if (lock == null) break block7;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (lock == null) {
                    System.out.println("could not get lock2 in phyp event handler");
                    throw throwable;
                }
                try {
                    lock.unlock();
                    System.out.println("released the cimom cec lock2 in phyp event handler");
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable2.printStackTrace();
                    throw throwable;
                }
            }
            try {}
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return;
            }
            lock.unlock();
            System.out.println("released the cimom cec lock2 in phyp event handler");
            return;
        }
        System.out.println("could not get lock2 in phyp event handler");
    }

    private void acknowledgePHYPEvent(byte[] byArray) {
        try {
            this.mSysMgr.getCmdHelper().lparAsyncAcknowledge(byArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void handleVspEvent(PIParseResponse pIParseResponse) {
        try {
            Hashtable hashtable = pIParseResponse.getParsedData(VSP_ASYNC_STATE_CHANGE);
            UnsignedInt16 unsignedInt16 = (UnsignedInt16)hashtable.get(VSP_EVENT_LENGTH);
            if (unsignedInt16 == null || unsignedInt16.intValue() == 0) {
                return;
            }
            byte[] byArray = (byte[])hashtable.get(VSP_EVENT_MASK);
            int[] nArray = OmUtils.getInstance().getIdListFromMask(byArray);
            for (int i = 0; i < nArray.length; ++i) {
                Throwable throwable2222;
                Object var10_10;
                Lock lock;
                block15: {
                    lock = null;
                    lock = Lock.getInstance("root/ibmhscS1_0", ((OmCecMgr)this.mSysMgr).getCecName(), "" + nArray[i]);
                    lock.lock(4);
                    System.out.println("got the cimom lpar lock for " + nArray[i] + "  in vsp event handler");
                    ((OmCecMgr)this.mSysMgr).lparVspChanged(nArray[i]);
                    var10_10 = null;
                    if (lock == null) break block15;
                    try {
                        lock.unlock();
                        System.out.println("released the cimom lpar lock in vsp event handler");
                    }
                    catch (Throwable throwable2222) {
                        throwable2222.printStackTrace();
                    }
                    continue;
                }
                System.out.println("could not get lpar lock for " + nArray[i] + " in vsp event handler");
                {
                    continue;
                    catch (Throwable throwable3) {
                        throwable3.printStackTrace();
                        var10_10 = null;
                        if (lock != null) {
                            try {
                                lock.unlock();
                                System.out.println("released the cimom lpar lock in vsp event handler");
                            }
                            catch (Throwable throwable2222) {
                                throwable2222.printStackTrace();
                            }
                            continue;
                        }
                        System.out.println("could not get lpar lock for " + nArray[i] + " in vsp event handler");
                        continue;
                    }
                }
                catch (Throwable throwable4) {
                    var10_10 = null;
                    if (lock != null) {
                        try {
                            lock.unlock();
                            System.out.println("released the cimom lpar lock in vsp event handler");
                        }
                        catch (Throwable throwable2222) {
                            throwable2222.printStackTrace();
                        }
                    } else {
                        System.out.println("could not get lpar lock for " + nArray[i] + " in vsp event handler");
                    }
                    throw throwable4;
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void acknowledgeVspEvent(byte[] byArray) {
        try {
            this.mSysMgr.getCmdHelper().vspAsyncAcknowledge(byArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void handleVspSrcEvent(PIParseResponse pIParseResponse) {
        try {
            Hashtable hashtable = pIParseResponse.getParsedData(VSP_SRC_ASYNC_STATE_CHANGE);
            UnsignedInt16 unsignedInt16 = (UnsignedInt16)hashtable.get(VSP_EVENT_LENGTH);
            if (unsignedInt16 == null || unsignedInt16.intValue() == 0) {
                return;
            }
            byte[] byArray = (byte[])hashtable.get(VSP_EVENT_MASK);
            int[] nArray = OmUtils.getInstance().getIdListFromMask(byArray);
            for (int i = 0; i < nArray.length; ++i) {
                Throwable throwable2222;
                Object var10_10;
                Lock lock;
                block15: {
                    lock = null;
                    lock = Lock.getInstance("root/ibmhscS1_0", this.mSysMgr.getSysName(), "" + nArray[i]);
                    lock.lock(4);
                    System.out.println("got the cimom lpar lock for " + nArray[i] + "  in vsp src event handler");
                    ((OmCecMgr)this.mSysMgr).lparVspSrcChanged(nArray[i]);
                    var10_10 = null;
                    if (lock == null) break block15;
                    try {
                        lock.unlock();
                        System.out.println("released the cimom lpar lock in vsp event handler");
                    }
                    catch (Throwable throwable2222) {
                        throwable2222.printStackTrace();
                    }
                    continue;
                }
                System.out.println("could not get lpar lock for " + nArray[i] + " in vsp event handler");
                {
                    continue;
                    catch (Throwable throwable3) {
                        throwable3.printStackTrace();
                        var10_10 = null;
                        if (lock != null) {
                            try {
                                lock.unlock();
                                System.out.println("released the cimom lpar lock in vsp event handler");
                            }
                            catch (Throwable throwable2222) {
                                throwable2222.printStackTrace();
                            }
                            continue;
                        }
                        System.out.println("could not get lpar lock for " + nArray[i] + " in vsp event handler");
                        continue;
                    }
                }
                catch (Throwable throwable4) {
                    var10_10 = null;
                    if (lock != null) {
                        try {
                            lock.unlock();
                            System.out.println("released the cimom lpar lock in vsp event handler");
                        }
                        catch (Throwable throwable2222) {
                            throwable2222.printStackTrace();
                        }
                    } else {
                        System.out.println("could not get lpar lock for " + nArray[i] + " in vsp event handler");
                    }
                    throw throwable4;
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void acknowledgeVspSrcEvent(byte[] byArray) {
        try {
            this.mSysMgr.getCmdHelper().vspSrcAsyncAcknowledge(byArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleCodEvent(byte[] byArray, PIParseResponse pIParseResponse) {
        block17: {
            Lock lock = null;
            CodAsyncMsg[] codAsyncMsgArray = null;
            String string = ((OmCecMgr)this.mSysMgr).getCecName();
            try {
                try {
                    int n;
                    lock = Lock.getInstance("root/ibmhscS1_0", string);
                    lock.lock(4);
                    FspCodAsyncEventData fspCodAsyncEventData = this.mSysMgr.getCmdHelper().getCodAsyncEventData(pIParseResponse);
                    BitSet bitSet = fspCodAsyncEventData.getEventMask();
                    ((OmCecMgr)this.mSysMgr).codChanged(fspCodAsyncEventData);
                    if (bitSet.get(12)) {
                        this.handSvrEvtSubs(1, byArray);
                    }
                    if (bitSet.get(13)) {
                        this.handSvrEvtSubs(1, byArray);
                    }
                    if (bitSet.get(0)) {
                        this.handSvrEvtSubs(1, byArray);
                    }
                    if (bitSet.get(1)) {
                        this.handSvrEvtSubs(1, byArray);
                    }
                    if (bitSet.get(2) && (n = fspCodAsyncEventData.getMsgListLength().intValue()) > 0) {
                        codAsyncMsgArray = fspCodAsyncEventData.getMsgList();
                        OmCecSendCoDAsyncMsg omCecSendCoDAsyncMsg = new OmCecSendCoDAsyncMsg(string, (OmCecMgr)this.mSysMgr, codAsyncMsgArray, n);
                        omCecSendCoDAsyncMsg.start();
                    }
                    if (bitSet.get(9)) {
                        n = 1;
                        ((OmCecMgr)this.mSysMgr).phypStateChangedAction();
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    Object var14_12 = null;
                    if (lock == null) {
                        System.out.println("could not get lock for cod event");
                        return;
                    }
                    try {
                        lock.unlock();
                        System.out.println("released the cimom cec lock in cod event handler");
                        return;
                    }
                    catch (Throwable throwable2) {
                        throwable2.printStackTrace();
                        return;
                    }
                }
                Object var14_11 = null;
                if (lock == null) break block17;
            }
            catch (Throwable throwable) {
                Object var14_13 = null;
                if (lock == null) {
                    System.out.println("could not get lock for cod event");
                    throw throwable;
                }
                try {}
                catch (Throwable throwable3) {
                    throwable3.printStackTrace();
                    throw throwable;
                }
                lock.unlock();
                System.out.println("released the cimom cec lock in cod event handler");
                throw throwable;
            }
            try {}
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return;
            }
            lock.unlock();
            System.out.println("released the cimom cec lock in cod event handler");
            return;
        }
        System.out.println("could not get lock for cod event");
    }

    private void acknowledgeCodEvent(byte[] byArray) {
        try {
            this.mSysMgr.getCmdHelper().codAsyncAcknowledge(byArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private int handleHypervisorPipeEvent(byte[] byArray, PIParseResponse pIParseResponse) {
        long l = 0L;
        long l2 = 255L;
        for (int i = 32; i < 40; ++i) {
            System.out.println("payload[" + i + "] = " + byArray[i]);
            l <<= 8;
            l |= (long)byArray[i] & l2;
        }
        System.out.println("Is handleHypervisorPipeEvent id is: " + Integer.toHexString((int)l));
        try {
            String string = this.mSysMgr.getCmdMgr().getHypPipeAsychCmd((int)l);
            Hashtable hashtable = null;
            if (string.equals(HYPER_PIPE_RESP_ASYNC_EXCH_CAPS)) {
                try {
                    hashtable = pIParseResponse.getParsedData(string);
                    System.out.println("The parsed data is: " + hashtable);
                }
                catch (Throwable throwable) {
                    System.out.println("EXCHANGE CAPS PARSE ERROR!");
                    throwable.printStackTrace();
                    PIParseResponse pIParseResponse2 = new PIParseResponse(byArray);
                    hashtable = pIParseResponse2.getParsedData(HYPER_PIPE_RESP_ASYNC);
                    System.out.println("Retry - the parsed data is: " + hashtable);
                }
            } else {
                hashtable = pIParseResponse.getParsedData(string);
                System.out.println("The parsed data is: " + hashtable);
            }
            int n = this.mSysMgr.getCmdMgr().processGroupResponse(byArray, (int)l);
            System.out.println("cmd mgr returns " + n);
            if (n == 1) {
                System.out.println("calling handleDiscardMsg");
                ((OmCecMgr)this.mSysMgr).handleDiscardMsg(hashtable, (int)l);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return (int)l;
    }

    private void acknowledgeHypPipeResponse(byte[] byArray, int n) {
        try {
            System.out.println("calling hypPipeResponseAcknowledge()");
            System.out.println("correlator ID: " + byArray);
            System.out.println("request ID: " + n);
            this.mSysMgr.getCmdHelper().hypPipeResponseAcknowledge(byArray, n);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void handleError(Throwable throwable) {
        throwable.printStackTrace();
    }
}

